/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.item;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9275;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import toni.sodiumdynamiclights.SodiumDynamicLights;

public abstract class ItemLightSource {
    private final class_2960 id;
    private final class_1792 item;
    private final boolean waterSensitive;

    public ItemLightSource(class_2960 id, class_1792 item, boolean waterSensitive) {
        this.id = id;
        this.item = item;
        this.waterSensitive = waterSensitive;
    }

    public ItemLightSource(class_2960 id, class_1792 item) {
        this(id, item, false);
    }

    public class_2960 id() {
        return this.id;
    }

    public class_1792 item() {
        return this.item;
    }

    public boolean waterSensitive() {
        return this.waterSensitive;
    }

    public int getLuminance(class_1799 stack, boolean submergedInWater) {
        if (this.waterSensitive() && ((Boolean)SodiumDynamicLights.get().config.getWaterSensitiveCheck().get()).booleanValue() && submergedInWater) {
            return 0;
        }
        return this.getLuminance(stack);
    }

    public abstract int getLuminance(class_1799 var1);

    public String toString() {
        return "ItemLightSource{id=" + String.valueOf(this.id()) + "item=" + String.valueOf(this.item()) + ", water_sensitive=" + this.waterSensitive() + "}";
    }

    @NotNull
    public static Optional<ItemLightSource> fromJson(@NotNull class_2960 id, @NotNull JsonObject json) {
        JsonPrimitive luminanceElement;
        if (!json.has("item") || !json.has("luminance")) {
            SodiumDynamicLights.get().warn("Failed to parse item light source \"" + String.valueOf(id) + "\", invalid format: missing required fields.");
            return Optional.empty();
        }
        class_2960 affectId = class_2960.method_12829((String)json.get("item").getAsString());
        Optional ref = class_7923.field_41178.method_10223(affectId);
        if (ref.isEmpty()) {
            return Optional.empty();
        }
        class_1792 item = (class_1792)((class_6880.class_6883)ref.get()).comp_349();
        if (item == class_1802.field_8162) {
            return Optional.empty();
        }
        boolean waterSensitive = false;
        if (json.has("water_sensitive")) {
            waterSensitive = json.get("water_sensitive").getAsBoolean();
        }
        if ((luminanceElement = json.get("luminance").getAsJsonPrimitive()).isNumber()) {
            return Optional.of(new StaticItemLightSource(id, item, luminanceElement.getAsInt(), waterSensitive));
        }
        if (luminanceElement.isString()) {
            String luminanceStr = luminanceElement.getAsString();
            if (luminanceStr.equals("block")) {
                if (item instanceof class_1747) {
                    class_1747 blockItem = (class_1747)item;
                    return Optional.of(new BlockItemLightSource(id, item, blockItem.method_7711().method_9564(), waterSensitive));
                }
            } else {
                class_2248 block;
                class_2960 blockId = class_2960.method_12829((String)luminanceStr);
                if (blockId != null && (block = (class_2248)((class_6880.class_6883)class_7923.field_41175.method_10223(blockId).get()).comp_349()) != class_2246.field_10124) {
                    return Optional.of(new BlockItemLightSource(id, item, block.method_9564(), waterSensitive));
                }
            }
        } else {
            SodiumDynamicLights.get().warn("Failed to parse item light source \"" + String.valueOf(id) + "\", invalid format: \"luminance\" field value isn't string or integer.");
        }
        return Optional.empty();
    }

    public static class StaticItemLightSource
    extends ItemLightSource {
        private final int luminance;

        public StaticItemLightSource(class_2960 id, class_1792 item, int luminance, boolean waterSensitive) {
            super(id, item, waterSensitive);
            this.luminance = luminance;
        }

        public StaticItemLightSource(class_2960 id, class_1792 item, int luminance) {
            super(id, item);
            this.luminance = luminance;
        }

        @Override
        public int getLuminance(class_1799 stack) {
            return this.luminance;
        }
    }

    public static class BlockItemLightSource
    extends ItemLightSource {
        private final class_2680 mimic;

        public BlockItemLightSource(class_2960 id, class_1792 item, class_2680 block, boolean waterSensitive) {
            super(id, item, waterSensitive);
            this.mimic = block;
        }

        @Override
        public int getLuminance(class_1799 stack) {
            return BlockItemLightSource.getLuminance(stack, this.mimic);
        }

        static int getLuminance(class_1799 stack, class_2680 state) {
            class_9275 nbt = (class_9275)stack.method_57353().method_58695(class_9334.field_49623, (Object)class_9275.field_49284);
            if (!nbt.method_57414()) {
                state = nbt.method_57415(state);
            }
            return state.method_26213();
        }
    }
}

