/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumoptionsapi.gui;

import java.util.concurrent.atomic.AtomicReference;
import me.flashyreese.mods.reeses_sodium_options.client.gui.Dim2iExtended;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.components.ScrollBarComponent;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_332;
import toni.sodiumoptionsapi.gui.AbstractFrame;

public class ScrollableFrame
extends AbstractFrame {
    protected final Dim2i frameOrigin;
    protected final AbstractFrame frame;
    private boolean canScrollHorizontal;
    private boolean canScrollVertical;
    private Dim2i viewPortDimension = null;
    private ScrollBarComponent verticalScrollBar = null;
    private ScrollBarComponent horizontalScrollBar = null;

    public ScrollableFrame(Dim2i dim, AbstractFrame frame, boolean renderOutline, AtomicReference<Integer> verticalScrollBarOffset, AtomicReference<Integer> horizontalScrollBarOffset) {
        super(dim, renderOutline);
        this.frame = frame;
        this.frameOrigin = new Dim2i(frame.dim.x(), frame.dim.y(), 0, 0);
        this.setupFrame(verticalScrollBarOffset, horizontalScrollBarOffset);
        this.buildFrame();
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public void setupFrame(AtomicReference<Integer> verticalScrollBarOffset, AtomicReference<Integer> horizontalScrollBarOffset) {
        int maxWidth = 0;
        int maxHeight = 0;
        if (!((Dim2iExtended)this.dim).canFitDimension(this.frame.dim)) {
            int value;
            if (this.dim.getLimitX() < this.frame.dim.getLimitX() && maxWidth < (value = this.frame.dim.x() - this.dim.x() + this.frame.dim.width())) {
                maxWidth = value;
            }
            if (this.dim.getLimitY() < this.frame.dim.getLimitY() && maxHeight < (value = this.frame.dim.y() - this.dim.y() + this.frame.dim.height())) {
                maxHeight = value;
            }
        }
        if (maxWidth > 0) {
            this.canScrollHorizontal = true;
        }
        if (maxHeight > 0) {
            this.canScrollVertical = true;
        }
        if (this.canScrollHorizontal && this.canScrollVertical) {
            this.viewPortDimension = new Dim2i(this.dim.x(), this.dim.y(), this.dim.width() - 11, this.dim.height() - 11);
        } else if (this.canScrollHorizontal) {
            this.viewPortDimension = new Dim2i(this.dim.x(), this.dim.y(), this.dim.width(), this.dim.height() - 11);
            this.frame.dim = this.withHeight(this.frame.dim, this.frame.dim.height() - 11);
        } else if (this.canScrollVertical) {
            this.viewPortDimension = new Dim2i(this.dim.x(), this.dim.y(), this.dim.width() - 11, this.dim.height());
            this.frame.dim = this.withWidth(this.frame.dim, this.frame.dim.width() - 11);
        }
        if (this.canScrollHorizontal) {
            this.horizontalScrollBar = new ScrollBarComponent(new Dim2i(this.viewPortDimension.x(), this.viewPortDimension.getLimitY() + 1, this.viewPortDimension.width(), 10), ScrollBarComponent.ScrollDirection.HORIZONTAL, this.frame.dim.width(), this.viewPortDimension.width(), offset -> horizontalScrollBarOffset.set((Integer)offset));
            this.horizontalScrollBar.setOffset(horizontalScrollBarOffset.get().intValue());
        }
        if (this.canScrollVertical) {
            this.verticalScrollBar = new ScrollBarComponent(new Dim2i(this.viewPortDimension.getLimitX() + 1, this.viewPortDimension.y(), 8, this.viewPortDimension.height()), ScrollBarComponent.ScrollDirection.VERTICAL, this.frame.dim.height(), this.viewPortDimension.height(), offset -> verticalScrollBarOffset.set((Integer)offset), this.viewPortDimension);
            this.verticalScrollBar.setOffset(verticalScrollBarOffset.get().intValue());
        }
    }

    public Dim2i withHeight(Dim2i ths, int newHeight) {
        return new Dim2i(ths.x(), ths.y(), ths.width(), newHeight);
    }

    public Dim2i withWidth(Dim2i ths, int newWidth) {
        return new Dim2i(ths.x(), ths.y(), newWidth, ths.height());
    }

    @Override
    public void buildFrame() {
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        if (this.canScrollHorizontal) {
            this.verticalScrollBar.updateThumbLocation();
        }
        if (this.canScrollVertical) {
            this.verticalScrollBar.updateThumbLocation();
        }
        this.frame.buildFrame();
        this.children.add(this.frame);
        super.buildFrame();
        this.frame.registerFocusListener(element -> {
            if (element instanceof ControlElement) {
                ControlElement controlElement = (ControlElement)element;
                if (this.canScrollVertical) {
                    Dim2i dim = controlElement.getDimensions();
                    int inputOffset = this.verticalScrollBar.getOffset();
                    int elementTop = dim.y() - inputOffset;
                    int elementBottom = dim.getLimitY() - inputOffset;
                    if (elementTop <= this.viewPortDimension.y()) {
                        inputOffset += elementTop - this.viewPortDimension.y();
                    } else if (elementBottom >= this.viewPortDimension.getLimitY()) {
                        inputOffset += elementBottom - this.viewPortDimension.getLimitY();
                    }
                    this.verticalScrollBar.setOffset(inputOffset);
                }
            }
        });
    }

    private double applyOffset(ScrollBarComponent component, double coord, boolean negate) {
        if (component == null) {
            return coord;
        }
        return coord + (double)(component.getOffset() * (negate ? -1 : 1));
    }

    @Override
    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        if (this.canScrollHorizontal || this.canScrollVertical) {
            if (this.renderOutline) {
                this.drawBorder(drawContext, this.dim.x(), this.dim.y(), this.dim.getLimitX(), this.dim.getLimitY(), -5592406);
            }
            boolean mouseInViewport = this.viewPortDimension.containsCursor((double)mouseX, (double)mouseY);
            drawContext.method_44379(this.viewPortDimension.x(), this.viewPortDimension.y(), this.viewPortDimension.getLimitX(), this.viewPortDimension.getLimitY());
            drawContext.method_51448().method_22903();
            drawContext.method_51448().method_22904(this.applyOffset(this.horizontalScrollBar, 0.0, true), this.applyOffset(this.verticalScrollBar, 0.0, true), 0.0);
            super.method_25394(drawContext, mouseInViewport ? (int)this.applyOffset(this.horizontalScrollBar, mouseX, false) : -1, mouseInViewport ? (int)this.applyOffset(this.verticalScrollBar, mouseY, false) : -1, delta);
            drawContext.method_51448().method_22909();
            drawContext.method_44380();
        } else {
            super.method_25394(drawContext, mouseX, mouseY, delta);
        }
        if (this.canScrollHorizontal) {
            this.horizontalScrollBar.method_25394(drawContext, mouseX, mouseY, delta);
        }
        if (this.canScrollVertical) {
            this.verticalScrollBar.method_25394(drawContext, mouseX, mouseY, delta);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.canScrollHorizontal && this.horizontalScrollBar.method_25402(mouseX, mouseY, button) || this.canScrollVertical && this.verticalScrollBar.method_25402(mouseX, mouseY, button) || super.method_25402(this.applyOffset(this.horizontalScrollBar, mouseX, false), this.applyOffset(this.verticalScrollBar, mouseY, false), button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.canScrollHorizontal && this.horizontalScrollBar.method_25403(mouseX, mouseY, button, deltaX, deltaY) || this.canScrollVertical && this.verticalScrollBar.method_25403(mouseX, mouseY, button, deltaX, deltaY) || super.method_25403(this.applyOffset(this.horizontalScrollBar, mouseX, false), this.applyOffset(this.verticalScrollBar, mouseY, false), button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return this.canScrollHorizontal && this.horizontalScrollBar.method_25406(mouseX, mouseY, button) || this.canScrollVertical && this.verticalScrollBar.method_25406(mouseX, mouseY, button) || super.method_25406(this.applyOffset(this.horizontalScrollBar, mouseX, false), this.applyOffset(this.verticalScrollBar, mouseY, false), button);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double verticalAmount) {
        return this.canScrollHorizontal && this.horizontalScrollBar.method_25401(mouseX, mouseY, scrollX, verticalAmount) || this.canScrollVertical && this.verticalScrollBar.method_25401(mouseX, mouseY, scrollX, verticalAmount) || super.method_25401(this.applyOffset(this.horizontalScrollBar, mouseX, false), this.applyOffset(this.verticalScrollBar, mouseY, false), scrollX, verticalAmount);
    }

    public static class Builder {
        private boolean renderOutline = false;
        private Dim2i dim = null;
        private AbstractFrame frame = null;
        private AtomicReference<Integer> verticalScrollBarOffset = new AtomicReference<Integer>(0);
        private AtomicReference<Integer> horizontalScrollBarOffset = new AtomicReference<Integer>(0);

        public Builder setDimension(Dim2i dim) {
            this.dim = dim;
            return this;
        }

        public Builder shouldRenderOutline(boolean state) {
            this.renderOutline = state;
            return this;
        }

        public Builder setVerticalScrollBarOffset(AtomicReference<Integer> verticalScrollBarOffset) {
            this.verticalScrollBarOffset = verticalScrollBarOffset;
            return this;
        }

        public Builder setHorizontalScrollBarOffset(AtomicReference<Integer> horizontalScrollBarOffset) {
            this.horizontalScrollBarOffset = horizontalScrollBarOffset;
            return this;
        }

        public Builder setFrame(AbstractFrame frame) {
            this.frame = frame;
            return this;
        }

        public ScrollableFrame build() {
            return new ScrollableFrame(this.dim, this.frame, this.renderOutline, this.verticalScrollBarOffset, this.horizontalScrollBarOffset);
        }
    }
}

