/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.neoforge;

import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.AbstractModInitializer;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.util.ProxyUtil;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.minecraft.MinecraftRenderWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL32;

public class NeoforgeClientProxy
implements AbstractModInitializer.IEventProxy {
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static Mat4f currentModelViewMatrix = new Mat4f();
    public static Mat4f currentProjectionMatrix = new Mat4f();

    @Override
    public void registerEvents() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void clientTickEvent(ClientTickEvent.Pre event) {
        ClientApi.INSTANCE.clientTickEvent();
    }

    @SubscribeEvent
    public void clientLevelLoadEvent(LevelEvent.Load event) {
        LOGGER.info("level load");
        LevelAccessor level = event.getLevel();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)level;
        IClientLevelWrapper clientLevelWrapper = ClientLevelWrapper.getWrapper(clientLevel, true);
        ClientApi.INSTANCE.clientLevelLoadEvent(clientLevelWrapper);
    }

    @SubscribeEvent
    public void clientLevelUnloadEvent(LevelEvent.Unload event) {
        LOGGER.info("level unload");
        LevelAccessor level = event.getLevel();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)level;
        IClientLevelWrapper clientLevelWrapper = ClientLevelWrapper.getWrapper(clientLevel);
        ClientApi.INSTANCE.clientLevelUnloadEvent(clientLevelWrapper);
    }

    @SubscribeEvent
    public void rightClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        if (MC.clientConnectedToDedicatedServer()) {
            if (SharedApi.isChunkAtBlockPosAlreadyUpdating(event.getPos().getX(), event.getPos().getZ())) {
                return;
            }
            PriorityTaskPicker.Executor executor = ThreadPoolUtil.getFileHandlerExecutor();
            if (executor != null) {
                executor.execute(() -> {
                    Level level = event.getLevel();
                    ChunkAccess chunk = level.getChunk(event.getPos());
                    this.onBlockChangeEvent((LevelAccessor)level, chunk);
                });
            }
        }
    }

    @SubscribeEvent
    public void leftClickBlockEvent(PlayerInteractEvent.LeftClickBlock event) {
        if (MC.clientConnectedToDedicatedServer()) {
            if (SharedApi.isChunkAtBlockPosAlreadyUpdating(event.getPos().getX(), event.getPos().getZ())) {
                return;
            }
            PriorityTaskPicker.Executor executor = ThreadPoolUtil.getFileHandlerExecutor();
            if (executor != null) {
                executor.execute(() -> {
                    Level level = event.getLevel();
                    ChunkAccess chunk = level.getChunk(event.getPos());
                    this.onBlockChangeEvent((LevelAccessor)level, chunk);
                });
            }
        }
    }

    private void onBlockChangeEvent(LevelAccessor level, ChunkAccess chunk) {
        ILevelWrapper wrappedLevel = ProxyUtil.getLevelWrapper(level);
        SharedApi.INSTANCE.chunkBlockChangedEvent(new ChunkWrapper(chunk, wrappedLevel), wrappedLevel);
    }

    @SubscribeEvent
    public void registerKeyBindings(InputEvent.Key event) {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        if (event.getAction() != 1) {
            return;
        }
        ClientApi.INSTANCE.keyPressedEvent(event.getKey());
    }

    @SubscribeEvent
    public void beforeLevelRenderEvent(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            currentModelViewMatrix = McObjectConverter.Convert(event.getModelViewMatrix());
            currentProjectionMatrix = McObjectConverter.Convert(event.getProjectionMatrix());
        }
    }

    @SubscribeEvent
    public void afterLevelRenderEvent(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            try {
                MinecraftRenderWrapper.INSTANCE.finalLevelFrameBufferId = GL32.glGetInteger((int)36006);
            }
            catch (Error | Exception e) {
                LOGGER.error("Unexpected error in afterLevelRenderEvent: " + e.getMessage(), e);
            }
        }
    }

    private static LevelAccessor GetEventLevel(LevelEvent e) {
        return e.getLevel();
    }
}

