/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumextras;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.longs.LongLongMutablePair;
import it.unimi.dsi.fastutil.longs.LongLongPair;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import toni.sodiumextras.SodiumExtras;

public class EmbyTools {
    private static final Marker IT = MarkerManager.getMarker((String)"Tools");
    private static final LongLongPair[] BENCHTIMES = new LongLongPair[100];
    private static int BENCH_POS = 0;

    public static <T> T getLastValue(T[] value) {
        return value[value.length - 1];
    }

    public static Pair<String, String> resourceLocationPair(String res) {
        String[] r = res.split(":");
        try {
            Pair pair = Pair.of((Object)r[0], (Object)r[1]);
            return pair;
        }
        finally {
            r[0] = null;
            r[1] = null;
        }
    }

    public static void setValueInField(Class<?> clazz, String fieldName, Object from, Object value) {
        try {
            Field field = clazz.getField(fieldName);
            field.setAccessible(true);
            field.set(from, value);
        }
        catch (Exception e) {
            SodiumExtras.LOGGER.error("Cannot set value of '{}' from {}", (Object)fieldName, (Object)clazz.getName(), (Object)e);
        }
    }

    public static void invokeMethod(Class<?> clazz, String methodName, Object from, Object ... values) {
        try {
            Class[] types = new Class[values.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = values[i].getClass();
            }
            Method field = clazz.getMethod(methodName, types);
            field.setAccessible(true);
            field.invoke(from, values);
        }
        catch (Exception e) {
            SodiumExtras.LOGGER.error("Cannot invoke method '{}' from {}", (Object)methodName, (Object)clazz.getName(), (Object)e);
        }
    }

    public static class_124 colorByLow(int usage) {
        return usage < 9 ? class_124.field_1079 : (usage < 16 ? class_124.field_1061 : (usage < 30 ? class_124.field_1065 : class_124.field_1070));
    }

    public static class_124 colorByPercent(int usage) {
        return usage >= 100 ? class_124.field_1079 : (usage >= 90 ? class_124.field_1061 : (usage >= 75 ? class_124.field_1065 : class_124.field_1070));
    }

    public static String tintByLower(int usage) {
        return (usage < 9 ? class_124.field_1079 : (usage < 16 ? class_124.field_1061 : (usage < 30 ? class_124.field_1065 : class_124.field_1070))).toString() + usage;
    }

    public static String tintByPercent(long usage) {
        return (usage >= 100L ? class_124.field_1079 : (usage >= 90L ? class_124.field_1061 : (usage >= 75L ? class_124.field_1065 : class_124.field_1070))).toString() + usage;
    }

    public static boolean isWhitelisted(class_2960 entityOrTile, ModConfigSpec.ConfigValue<List<? extends String>> configValue) {
        for (String item : (List)configValue.get()) {
            Pair<String, String> resLoc = EmbyTools.resourceLocationPair(item);
            if (!((String)resLoc.key()).equals(entityOrTile.method_12836()) || !((String)resLoc.value()).equals("*") && !((String)resLoc.value()).equals(entityOrTile.method_12832())) continue;
            return true;
        }
        return false;
    }

    public static int getColorARGB(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static long ramUsed() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static long bytesToMB(long input) {
        return input / 1024L / 1024L;
    }

    public static boolean isModInstalled(String modid) {
        return false;
    }

    public static boolean isEntityWithinDistance(class_1657 player, class_1297 entity, int maxHeight, int maxDistanceSquare) {
        if (Math.abs(player.method_23318() - entity.method_23318() - 4.0) < (double)maxHeight) {
            double z;
            double x = player.method_23317() - entity.method_23317();
            return x * x + (z = player.method_23321() - entity.method_23321()) * z < (double)maxDistanceSquare;
        }
        return false;
    }

    public static boolean isEntityWithinDistance(class_2338 bePos, class_243 camVec, int maxHeight, int maxDistanceSquare) {
        if (Math.abs((double)bePos.method_10264() - camVec.field_1351 - 4.0) < (double)maxHeight) {
            double z;
            double x = (double)bePos.method_10263() - camVec.field_1352;
            return x * x + (z = (double)bePos.method_10260() - camVec.field_1350) * z < (double)maxDistanceSquare;
        }
        return false;
    }

    public static boolean isEntityWithinDistance(class_1297 entity, double cameraX, double cameraY, double cameraZ, int maxHeight, int maxDistanceSquare) {
        if (Math.abs(entity.method_23318() - cameraY - 4.0) < (double)maxHeight) {
            double z;
            double x = entity.method_23317() - cameraX;
            return x * x + (z = entity.method_23321() - cameraZ) * z < (double)maxDistanceSquare;
        }
        return false;
    }

    public static void benchStart() {
        EmbyTools.BENCHTIMES[EmbyTools.BENCH_POS] = new LongLongMutablePair(class_156.method_648(), -1L);
    }

    public static void benchEnd() {
        BENCHTIMES[BENCH_POS].right(class_156.method_648());
        SodiumExtras.LOGGER.debug("Current method takes RIGHT NOW {} nanoseconds", (Object)(BENCHTIMES[BENCH_POS].rightLong() - BENCHTIMES[BENCH_POS].leftLong()));
        if (BENCH_POS == BENCHTIMES.length - 1) {
            long totalStart = 0L;
            long totalEnd = 0L;
            for (int i = 0; i < BENCHTIMES.length; ++i) {
                totalStart += BENCHTIMES[i].firstLong();
                totalEnd += BENCHTIMES[i].secondLong();
            }
            SodiumExtras.LOGGER.info("Current method takes AVG {} nanoseconds", (Object)((totalEnd - totalStart) / (long)BENCHTIMES.length));
            BENCH_POS = 0;
        } else {
            ++BENCH_POS;
        }
    }
}

