/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.nettakrim.signed_paintings.SignedPaintingsClient;
import com.nettakrim.signed_paintings.access.AbstractSignEditScreenAccessor;
import com.nettakrim.signed_paintings.access.SignBlockEntityAccessor;
import com.nettakrim.signed_paintings.gui.BackgroundClick;
import com.nettakrim.signed_paintings.gui.InputSlider;
import com.nettakrim.signed_paintings.gui.SignEditingInfo;
import com.nettakrim.signed_paintings.gui.UIHelper;
import com.nettakrim.signed_paintings.rendering.PaintingInfo;
import com.nettakrim.signed_paintings.rendering.SignSideInfo;
import com.nettakrim.signed_paintings.util.DiscordAlias;
import com.nettakrim.signed_paintings.util.ImageManager;
import com.nettakrim.signed_paintings.util.SignByteMapper;
import java.util.ArrayList;
import net.minecraft.class_2508;
import net.minecraft.class_2561;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3728;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_498;
import net.minecraft.class_7743;
import net.minecraft.class_8242;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_7743.class})
public abstract class AbstractSignEditScreenMixin
extends class_437
implements AbstractSignEditScreenAccessor {
    @Shadow
    private class_8242 field_43362;
    @Final
    @Shadow
    private String[] field_40425;
    @Final
    @Shadow
    protected class_2625 field_40424;
    @Final
    @Shadow
    private boolean field_43363;
    @Shadow
    private int field_40428;
    @Shadow
    private class_3728 field_40429;
    @Unique
    private String uploadURL = null;
    @Unique
    private class_339 uploadButton;
    @Unique
    private class_339 doneButton;

    protected AbstractSignEditScreenMixin(class_2561 title) {
        super(title);
    }

    @Shadow
    protected abstract void method_49913(String var1);

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawCenteredTextWithShadow(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;III)V")})
    private boolean shouldRenderTitle(class_332 context, class_327 textRenderer, class_2561 text, int centerX, int y, int color) {
        return !this.isInfoCorrect();
    }

    @WrapOperation(method={"renderSign"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/AbstractSignEditScreen;translateForRender(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/block/BlockState;)V")})
    private void translateForRender(class_7743 instance, class_332 context, class_2680 blockState, Operation<Void> original) {
        if (this.isInfoCorrect()) {
            if (this.getClass().equals(class_498.class)) {
                boolean bl = blockState.method_26204() instanceof class_2508;
                if (bl) {
                    context.method_51448().method_46416(0.0f, -16.0f, 0.0f);
                } else {
                    context.method_51448().method_46416(0.0f, -4.0f, 0.0f);
                }
            }
            context.method_51448().method_46416(86.5f, 38.0f, 50.0f);
            context.method_51448().method_22905(0.5f, 0.5f, 0.5f);
        } else {
            original.call(new Object[]{instance, context, blockState});
        }
    }

    @Unique
    private PaintingInfo getInfo() {
        SignBlockEntityAccessor sign = (SignBlockEntityAccessor)this.field_40424;
        return this.field_43363 ? sign.signedPaintings$getFrontPaintingInfo() : sign.signedPaintings$getBackPaintingInfo();
    }

    @Unique
    private boolean isInfoCorrect() {
        PaintingInfo info = this.getInfo();
        return info != null && info.isReady();
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.isInfoCorrect() || UIHelper.isBackgroundEnabled()) {
            super.method_25420(context, mouseX, mouseY, delta);
        }
    }

    @Redirect(method={"renderSignText"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/AbstractSignEditScreen;getTextScale()Lorg/joml/Vector3f;"))
    private Vector3f modifyGetTextScale(class_7743 instance) {
        return new Vector3f(1.0f, 1.0f, 1.0f);
    }

    @Inject(at={@At(value="TAIL")}, method={"init"})
    private void init(CallbackInfo ci) {
        this.doneButton = (class_339)this.method_25396().get(0);
        UIHelper.init(this.field_43363, this, (SignBlockEntityAccessor)this.field_40424, this::upload);
        ArrayList<class_339> uiButtons = UIHelper.getButtons();
        for (class_339 widget : uiButtons) {
            this.method_37063((class_364)widget);
            this.method_25429((class_364)widget);
        }
        this.uploadButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"signed_paintings.upload_prompt"), this::upload).method_46434(this.field_22789 / 2 - 100, this.field_22790 / 4 + 144 - 25, 200, 20).method_46431();
        this.method_37063((class_364)this.uploadButton);
        this.method_25429((class_364)this.uploadButton);
        BackgroundClick backgroundClick = new BackgroundClick(UIHelper.getInputSliders());
        this.method_25429((class_364)backgroundClick);
        UIHelper.addButton(backgroundClick);
        SignedPaintingsClient.currentSignEdit.setSelectionManager(this.field_40429);
        this.signedPaintings$setVisibility(this.isInfoCorrect());
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/block/entity/SignBlockEntity;ZZLnet/minecraft/text/Text;)V"})
    private void onScreenOpen(class_2625 blockEntity, boolean front, boolean filtered, class_2561 title, CallbackInfo ci) {
        SignedPaintingsClient.currentSignEdit = new SignEditingInfo(blockEntity, this);
    }

    @Inject(at={@At(value="TAIL")}, method={"finishEditing"})
    private void onScreenClose(CallbackInfo ci) {
        SignedPaintingsClient.currentSignEdit = null;
    }

    @Inject(at={@At(value="HEAD")}, method={"keyPressed"}, cancellable=true)
    private void onKeyPress(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        for (InputSlider slider : UIHelper.getInputSliders()) {
            if (slider == null || !slider.isFocused() || !slider.keyPressed(keyCode, scanCode, modifiers)) continue;
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"charTyped"}, cancellable=true)
    private void onCharType(char chr, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        for (InputSlider slider : UIHelper.getInputSliders()) {
            if (slider == null || !slider.isFocused() || !slider.charTyped(chr, modifiers)) continue;
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
    }

    @ModifyVariable(at=@At(value="STORE"), method={"renderSignText"}, ordinal=0)
    private boolean stopTextCaret(boolean bl) {
        for (InputSlider slider : UIHelper.getInputSliders()) {
            if (slider == null || !slider.isFocused() || this.field_40429 == null) continue;
            this.field_40429.method_35731(this.field_40429.method_16201());
            return false;
        }
        return bl;
    }

    @Override
    public void signedPaintings$clear(boolean setText) {
        for (int i = 0; i < this.field_40425.length; ++i) {
            this.field_40425[i] = "";
            this.field_43362 = this.field_43362.method_49857(i, (class_2561)class_2561.method_43470((String)""));
        }
        if (setText) {
            this.field_40424.method_49840(this.field_43362, this.field_43363);
        }
        this.field_40428 = 0;
    }

    @Override
    public int signedPaintings$paste(String pasteString, int selectionStart, int selectionEnd, boolean setText) {
        int maxWidthPerLine = this.field_40424.method_45470();
        class_327 textRenderer = SignedPaintingsClient.client.field_1772;
        String url = SignedPaintingsClient.imageManager.applyURLInferences((String)pasteString);
        if (DiscordAlias.isDiscord(url)) {
            String encoded = DiscordAlias.encode(url);
            url = DiscordAlias.decode(encoded);
            if (encoded.split("\\?")[0].endsWith(".webp")) {
                this.uploadURL = url;
                this.uploadButton.field_22764 = true;
            } else {
                pasteString = encoded;
            }
        } else if (ImageManager.isValid((String)pasteString)) {
            if (SignedPaintingsClient.imageManager.domainBlocked(url) || (double)textRenderer.method_1727(SignedPaintingsClient.imageManager.getShortestURLInference(url)) > (double)maxWidthPerLine * 2.5) {
                this.uploadURL = url;
                this.uploadButton.field_22764 = true;
            } else {
                pasteString = url;
            }
        }
        if (!this.uploadButton.field_22764 && !SignedPaintingsClient.imageManager.domainBlocked(url) && (double)textRenderer.method_1727(url) > (double)maxWidthPerLine * 3.5) {
            pasteString = SignByteMapper.INITIALIZER_STRING + SignByteMapper.encode(SignedPaintingsClient.imageManager.getShortestURLInference(url));
        }
        String[] newMessages = new String[this.field_40425.length];
        System.arraycopy(this.field_40425, 0, newMessages, 0, this.field_40425.length);
        selectionStart = class_3532.method_15340((int)selectionStart, (int)0, (int)newMessages[this.field_40428].length());
        selectionEnd = class_3532.method_15340((int)selectionEnd, (int)0, (int)newMessages[this.field_40428].length());
        if (selectionStart > selectionEnd) {
            int temp = selectionEnd;
            selectionEnd = selectionStart;
            selectionStart = temp;
        }
        newMessages[this.field_40428] = newMessages[this.field_40428].substring(0, selectionStart) + (String)pasteString + newMessages[this.field_40428].substring(selectionEnd);
        int currentWidth = textRenderer.method_1727(newMessages[this.field_40428]);
        int cursor = selectionStart + ((String)pasteString).length();
        if (currentWidth < maxWidthPerLine) {
            this.method_49913(newMessages[this.field_40428]);
            return cursor;
        }
        int cursorRow = this.field_40428;
        while (true) {
            String line = newMessages[this.field_40428];
            int index = SignedPaintingsClient.getMaxFittingIndex(line, maxWidthPerLine, textRenderer);
            newMessages[this.field_40428] = line.substring(0, index);
            if (this.field_40428 == this.field_40425.length - 1 || line.length() <= index) break;
            if (this.field_40428 == cursorRow && cursor > index) {
                ++cursorRow;
                cursor -= index;
            }
            ++this.field_40428;
            newMessages[this.field_40428] = line.substring(index) + newMessages[this.field_40428];
        }
        cursor = class_3532.method_15340((int)cursor, (int)0, (int)newMessages[cursorRow].length());
        for (int i = 0; i < this.field_40425.length; ++i) {
            this.field_40425[i] = newMessages[i];
            this.field_43362 = this.field_43362.method_49857(i, (class_2561)class_2561.method_43470((String)this.field_40425[i]));
        }
        if (setText) {
            this.field_40424.method_49840(this.field_43362, this.field_43363);
        }
        this.field_40428 = cursorRow;
        return cursor;
    }

    @Unique
    private void upload(class_4185 button) {
        if (this.uploadURL == null) {
            return;
        }
        SignedPaintingsClient.uploadManager.uploadUrlToImgur(this.uploadURL, this::uploadFinished);
    }

    @Unique
    private void uploadFinished(String link) {
        if (!SignedPaintingsClient.currentSignEdit.sign.equals(this.field_40424)) {
            return;
        }
        this.uploadURL = null;
        if (link == null) {
            this.uploadButton.method_25355((class_2561)class_2561.method_43471((String)"signed_paintings.upload_fail"));
            return;
        }
        this.uploadButton.field_22764 = false;
        this.signedPaintings$clear(false);
        this.signedPaintings$paste(link, 0, 0, false);
        ((SignBlockEntityAccessor)this.field_40424).signedPaintings$getSideInfo(this.field_43363).loadPainting(this.field_43363, this.field_40424, true);
    }

    @Override
    public void signedPaintings$setVisibility(boolean to) {
        for (class_339 clickableWidget : UIHelper.getButtons()) {
            if (clickableWidget == null) continue;
            clickableWidget.field_22764 = to;
        }
        if (this.doneButton != null) {
            boolean bl = this.doneButton.field_22764 = !to;
        }
        if (this.uploadButton != null) {
            this.uploadButton.field_22764 = this.uploadURL != null && !to;
            UIHelper.setUploadVisibility(this.uploadURL != null && to);
        }
    }

    @Override
    public void signedPaintings$initSliders(SignSideInfo info) {
        UIHelper.updateUI(info);
    }

    @Override
    public String signedPaintings$getText() {
        StringBuilder s = new StringBuilder();
        for (String message : this.field_40425) {
            s.append(message);
        }
        return s.toString();
    }
}

