/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings.rendering;

import com.nettakrim.signed_paintings.SignedPaintingsClient;
import com.nettakrim.signed_paintings.rendering.Cuboid;
import com.nettakrim.signed_paintings.util.ImageData;
import net.minecraft.class_2960;

public class OverlayInfo {
    public Cuboid cuboid;
    private ImageData image;

    public void loadOverlay(String text) {
        this.invalidateImage();
        String url = SignedPaintingsClient.imageManager.applyURLInferences(text);
        SignedPaintingsClient.imageManager.loadImage(url, this::updateImage);
    }

    public void updateImage(ImageData image) {
        this.image = image;
        this.updateCuboid();
    }

    private void updateCuboid() {
        this.cuboid = Cuboid.CreateOverlayCuboid((float)this.image.width / (float)this.image.height);
    }

    public void invalidateImage() {
        this.image = null;
    }

    public boolean isReady() {
        return this.image != null && this.image.ready;
    }

    public boolean needsReload() {
        return this.image != null && this.image.needsReload;
    }

    public class_2960 getImageIdentifier() {
        return this.image.getBaseIdentifier();
    }
}

